/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.domain.use_case;

import com.android.core.domain.model.GenericResponse;
import com.android.files.domain.util.AndroidFilesHandler;
import com.android.files.domain.util.BinaryDataService;
import com.android.files.domain.util.BinaryServiceFactory;
import com.android.files.domain.util.FileIdData;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SaveCustomerPic {
    private final DbConnection dbConnection;

    public GenericResponse invoke(MultipartFile file) {
        long serverId;
        BinaryDataService binaryService = BinaryServiceFactory.getDataService((DbConnection)this.dbConnection, (LoginDto)SecurityConstants.loadToken());
        try {
            serverId = binaryService.store(file, AndroidFilesHandler.PictureType.Customer);
        }
        catch (Exception e) {
            throw TncException.fromException((Throwable)e);
        }
        String clientId = new FileIdData(Objects.requireNonNull(file.getOriginalFilename())).getId();
        return GenericResponse.builder().requestIdentifier(clientId).generatedCode(String.valueOf(serverId)).clientId(ConvertStr.parseNullSafeLong((String)clientId)).message("\u0639\u06a9\u0633 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f").build();
    }

    public SaveCustomerPic(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

